function fitness = evaluate(fun, pop),
%EVALUATE  fitness function evaluation.
%
%  FITNESS = EVALUATE(FUN, POP) returns the value of the fitness function
%  FUN for each element of the population POP.
%
%  the fitness function must return a positive value, otherwise the
%  selection will not work correctly.  see BANANA for an example of a
%  fitness function.
%
%  see also GENETIC, INITIALIZE, SELECTION, MUTATION, CROSSOVER.

%  copyright (C) 1999 by Ernesto Rico-Schmidt <nene@sbox.tu-graz.ac.at>
%  all rights reversed.  see COPYING for more information.
%
%  $Id: evaluate.m,v 1.1 1999/07/24 17:14:05 ernesto Exp $

for i = 1:size(pop,1),
    fitness(i,1) = feval(fun, pop(i,:));
end

if any(fitness<0),
    disp('genetic: negative fitness encountered.');
end
