function subpop = selection(pop, fitness)
%SELECTION  fitness-proportionate selection.
%
%  SUBPOP = SELECTION(POP, FITNESS) returns a subset SUBPOP of the
%  population POP based on the fitness FITNESS.  for each element of the
%  population the probability of beeing selected is proportional its
%  fitness.
%
%  see also GENETIC, INITIALIZE, EVALUATE, MUTATION, CROSSOVER.

%  copyright (C) 1999 by Ernesto Rico-Schmidt <nene@sbox.tu-graz.ac.at>
%  all rights reversed.  see COPYING for more information.
%
%  $Id: selection.m,v 1.2 2002/08/23 14:22:27 ernesto Exp $

% sort before we start
%
[fitness, index] = sort(fitness);
pop = pop(index,:);

prob = cumsum(fitness/sum(fitness));

selected = find(rand(size(pop,1),1)<prob);
n = length(selected);

subpop = pop(selected,:);

% return an even-sized population
%
if rem(n,2)==1,
    subpop = subpop(2:n,:);
end
