function newpop = mutation(oldpop, bounds, Pm)
%MUTATION  uniform mutation.
%
%  NEWPOP = MUTATION(OLDPOP, BOUNDS, Pm) returns a new population NEWPOP
%  resulting of performing an uniform mutation on the population OLDPOP with
%  a probability of Pm.
%
%  see also GENETIC, INITIALIZE, EVALUATE, SELECTION, CROSSOVER.

%  copyleft (C) 1999 by Ernesto Rico-Schmidt <nene@sbox.tu-graz.ac.at>
%  all rights reversed.  see COPYING for more information.
%
%  $Id: mutation.m,v 1.2 2002/08/23 14:21:21 ernesto Exp $

n = size(oldpop,1);
delta = bounds(2,:) - bounds(1,:);

if any(delta<0),
  error('some lower bound seems to be bigger than a upper bound.');
end

newpop = [];

for i = 1:n,
    if rand<Pm,
        newpop = [newpop; bounds(1,:) + rand(size(delta)) .* delta];
    end
end
