function pop = initialize(popsize, bounds)
%INITIALIZE  create the start population.
%
%  POP = INITIALIZE(POPSIZE, BOUNDS) returns a random population POP of the
%  size POPSIZE within the lower bound BOUNDS(1,:) and the upper bound
%  BOUNDS(2,:).
%
%  see also GENETIC, EVALUATE, SELECTION, MUTATION, CROSSOVER.

%  copyleft (C) 1999 by Ernesto Rico-Schmidt <nene@sbox.tu-graz.ac.at>
%  all rights reversed.  see COPYING for more information.
%
%  $Id: initialize.m,v 1.2 2002/08/23 14:19:37 ernesto Exp $

% initial population should be even
%
if rem(popsize,2)==1,
   disp('Warning: population size should be even, adding one to it.')
   popsize = popsize + 1;
end

delta = bounds(2,:) - bounds(1,:);

if any(delta<0),
  error('some lower bound seems to be bigger than a upper bound.');
end

pop = ones(popsize,1)*bounds(1,:) + rand(popsize,size(bounds,2));
