%DEMO of the simple genetic algorithm implementation GENETIC.

%  copyleft (C) 1999 by Ernesto Rico-Schmidt <nene@sbox.tu-graz.ac.at>
%  all rights reversed.  see COPYING for more information.
%
%  $Id: demo.m,v 1.2 2002/08/23 14:16:08 ernesto Exp $

echo on
% recall the Rosenbrock's (aka banana) function
%   f = 100*(x(2) - x(1)^2)^2 + (1 - x(1))^2
%
% since the algorithm tries to maximize the fitness function, and since
% the fitness is expected to be always positive, we need to sligthly
% modify the banana function to meet our needs:
%   f = 2000 - (100*(x(2) - x(1)^2)^2 + (1 - x(1))^2)
%

pause					% hit any key to continue
% now, the goal is to find a maximum of the function in the range
%   0 < x(1) < 2
%   0 < x(2) < 2
%
bounds = [0 0; 2 2];

pause					% hit any key to continue
% we then set the probability of crossover and the probability of mutation
% beeing performed to 0.6 and 0.4 respectively.  the initial population will
% have 20 individuals and the algorithm will stop if either 500 generations
% are reached or the standard deviation is within eps
%
options = [0.6 0.4 0 20 500 eps];

pause					% hit any key to continue
xopt = genetic('banana', bounds, options)

pause					% hit any key to continue
%   The difference between theory and practice tends to be very small,
%   in theory, but in practice it is very large indeeed.
%                                                        -- Anonymous
%
% if this fullfills and you don't get (at least approximately) [1 1], please
% drop me a mail at <nene@sbox.tu-graz.ac.at>

echo off

