function newpop = crossover(oldpop, Pc)
%CROSSOVER  arithmetic crossover.
%
%  NEWPOP = CROSSOVER(OLDPOP, Pc) returns a new population NEWPOP resulting
%  of performing arithmetic crossover on the population OLDPOP with the
%  probability Pc.
%
%  see also GENETIC, INITIALIZE, EVALUATE, SELECTION, MUTATION.

%  copyleft (C) 1999 by Ernesto Rico-Schmidt <nene@sbox.tu-graz.ac.at>
%  all rights reversed.  see COPYING for more information.
%
%  $Id: crossover.m,v 1.3 2002/08/23 14:53:29 ernesto Exp $

n = size(oldpop,1);

newpop = [];

index = randperm(n);

for i = 1:n/2-1,
  if rand<Pc,
    a = rand;
    x1 = oldpop(index(i),:);
    x2 = oldpop(n+1-i,:);
    newpop = [newpop; x1*a + x2*(1-a)];
    newpop = [newpop; x1*(1-a) + x2*a];
  end
end
