// File Name:   campict.java
//
// Description: Download and display a list of images with or without
//              reflesh/reload. Mainly for use with Axis Neteye 200
//-----------------------------------------------------------------------------
// History
//
// Date   Name           Ver        Changes  option
// ----   ----           ---        -------
// 960513 Le Chi Kiet    1.xx       --
// 961022 Le Chi Kiet    2.xx       New layout
// 961130 Le Chi Kiet    3.1x       New design
// 970130 Le Chi Kiet    3.2x       Add byPassCamCache
// 970214 Le Chi Kiet    3.3x       Take away byPassCamCache
//                                  Add OpenDoor
// 970130 Le Chi Kiet    3.4x       Add noStatusText
// 970319 Le Chi Kiet    4.0x       Standalone 'Options' window and Password
//                                  Changed OpenDoor to Relay On/Off
// 970406 Le Chi Kiet    4.1x       Standalone 'Config' window
//                                  Add manual garbage collector.
// ****************************************************************************
//   Copyright 1996-1997 Axis communications AB, Lund, SWEDEN
//  All rights reserved.
//  Email: Kiet.LeChi@axis.com or neteye@axis.com

import java.awt.*;
import java.net.*;
import java.util.*;
import java.io.*;

public final class campict extends MyApplet implements Runnable
{

   long nError=0;

   String version    = "Version 4.17 ";
   String homeLink   = "http://www.axis.com/neteye/campict/campict.html ";
   String imageHelpLink = "../pub/images.htm";
   String binaryFile = "campict ";

   String defaultImage      = "../fullsize.jpg|../halfsize.jpg";
   String defaultImageLabel = "fullsize.jpg  352288 pixels.|halfsize.jpg  176144 pixels.";

   URL codeBase;
   Vector imageList   = new Vector();
   Vector imageLabels = new Vector();
   boolean imgDefault = false;

   int current = 0, amountOfImages = 0;
   int interval = 0;
   int waitInt = 50;  //ms
   int maxLoadTime = 90000; //ms (here 90s)
   int msTimeLeft;

   Color bgColor = Color.white;
   Image currentImage = null;
   Vector imageBank   = new Vector();
   Thread engine;
   Image  axislogo1 = null;
   Image  axislogo2 = null;
   String axislogoLoc1 = "axislogo.gif";
   String axislogoLoc2 = "pub/images/axislogo.gif";
   int numOfLoaded = 0;

   boolean initError = false;
   boolean loaded    = false;
   boolean imgError  = false;
   boolean allLoaded = false;
   boolean showAbout = false;

   int frameWidth;
   int frameHeight;
   Image offScrImage;
   Graphics offScrGC;

   boolean noRefresh    = false;
   boolean noFrame      = false;
   boolean imgFitFrame  = false;
   boolean noOptions    = false;
   boolean noStatusText = false;
   boolean relayAuto    = true;
   boolean imgConfig    = false;

   Label m_status;
   Button m_option, m_about;
   String statusText = " ";

   PassFrame pass;
   String userName = "", password = "", indata="";

   ConfigFrame config;

   OptionFrame options;
   boolean showStatus[];
   boolean relayActionNotValid = false;

   String file, postParam;
   DataInputStream in;
   DataOutputStream out;

   Point framePos;
   int relayOnDelays;
   boolean relayWillOn  = true;

   int actionType;
   final int RELAY_ACTION = 1;
   final int CONFIG_GET   = 2;

  //--------------------------------------------------------
  // Init of the thread
  //--------------------------------------------------------
  public synchronized void init()
  {


    String string = null;
    int x ,y;

    System.out.println("Init applet...");

      // get color param from html-file
    bgColor = getParam("bgcolor", bgColor);
    super.init();

      // get "codeBase" from html-file
    codeBase  = getCodeBase();
    axislogo1 = getImage(codeBase, axislogoLoc1);
    prepareImage(axislogo1, this);
    axislogo2 = getImage(codeBase, axislogoLoc2);
    prepareImage(axislogo2, this);

      // get imageList and imageLabels
    string = getParam("DataFile");
    if (string!=null)
    {
      parseImageDataFromFile(string);
    }
    else
    {
      parseImageDataFromParam();
    }

      // get int param from html-file
    interval      = getParam("Interval", 3) * 1000;
    relayOnDelays = getParam("RelayAuto", 0) * 1000;

      // get boolean param from html-file
    noRefresh     = getParam("NoRefresh", noRefresh);
    imgFitFrame   = getParam("ImgFitFrame", imgFitFrame);
    noFrame       = getParam("NoFrame", noFrame);
    noOptions     = getParam("NoOptions", noOptions);
    noStatusText  = noOptions;
    imgConfig     = getParam("ImgConfig", imgConfig);

      // get the size from html-file
    frameWidth = size().width;
    frameHeight= noOptions ? size().height : size().height - 30;

    options = new OptionFrame(this);
    config  = new ConfigFrame(this);
    pass    = new PassFrame(this);
    framePos = new Point(100, 100);

      // define layout
    this.setLayout(null);
    this.addNotify();
    y = frameHeight + 4;
    x = frameWidth - 130;
    m_about = new Button(" About ");
    m_about.reshape(x,y,60,23);
    m_option = new Button("Options");
    m_option.reshape(x+70,y,60,23);
    m_status = new Label(" ");
    m_status.reshape(5,y,x-20,23);
    m_status.setBackground(bgColor);

    if (!noOptions)
    {
      this.add(m_about);
      this.add(m_option);
      this.add(m_status);
    }

      // create double buffer
    try
    {
      offScrImage = createImage(frameWidth, frameHeight+30);
      offScrGC = offScrImage.getGraphics();
      offScrGC.setColor(bgColor);
      offScrGC.fillRect(0, 0, frameWidth, frameHeight);
    } catch (Exception e)
      {
    	System.out.println("[init()] "+e);
        initError = true;
      }

    current = 0;
  }


  //------------------------------------------------------------------------
  //  get imageList and imageLabels from file
  //------------------------------------------------------------------------
  public synchronized void parseImageDataFromFile(String dataFile)
  {
    URL   dataFileURL = null;
    InputStream istream = null;
    DataInputStream dStream = null;
    String string;
    StringTokenizer imageStr;

    try
    {
      dataFileURL = new URL(getDocumentBase(), dataFile);
      istream = dataFileURL.openStream();
    } catch(MalformedURLException e)
      {
        initError   = true;
        dataFileURL = null;
        return;
      }
      catch(IOException e)
      {
        initError = true;
        System.out.println("Unable to open file " + dataFile);
        return;
      }

    dStream = new DataInputStream(istream);
    current = 0;
    try
    {
      string = dStream.readLine();
      while (string!=null)
      {
        imageStr = new StringTokenizer(string, "|");
        string = imageStr.nextToken();
        imageList.addElement(string);
        if (imageStr.hasMoreTokens())
        {
          string = imageStr.nextToken();
        }
        imageLabels.addElement(string);
        string = dStream.readLine();
        current++;
      }
    amountOfImages = current;
    } catch(IOException e)
      {
        initError = true;
        System.out.println(e+"Parsing data source failed!");
      }
  }


  //------------------------------------------------------------------------
  //  get imageList and imageLabels from html-param
  //------------------------------------------------------------------------
  public synchronized void parseImageDataFromParam()
  {
    String string;
    StringTokenizer imageStr;

      // get Image's filename from html-file
    string = getParameter("Image");
    if (string==null)
    {
      imgDefault = true;
      string = defaultImage;
    }
    imageStr = new StringTokenizer(string, "|");
    amountOfImages = imageStr.countTokens();
    while (imageStr.hasMoreTokens())
    {
      string = imageStr.nextToken();
      imageList.addElement(string);
      imageLabels.addElement(string);
    }

     // get Image's Label from html-file
    string = getParameter("ImageLabel");
    if (string==null && imgDefault)
    {
      string = defaultImageLabel;
    }
    if (string!=null)
    {
      StringTokenizer imageLabelStr = new StringTokenizer(string, "|");
      current = 0;
      while (imageLabelStr.hasMoreTokens())
      {
        string = imageLabelStr.nextToken();
        if (!(string.equals(" ")))
        {
          imageLabels.insertElementAt(string, current);
        }
        current++;
      }
    }
  }


  //--------------------------------------------------------
  // Start the thread
  //--------------------------------------------------------
  public synchronized void start()
  {
    if (initError)
    {
      m_status.setText("Fail in init!");
      return;
    }
      // start the thread
    if (engine==null)
    {
      engine = new Thread(this);
      engine.start();
      super.start();
      System.out.println("Start applet...");
      showAbout = false;
    }
  }


  //--------------------------------------------------------
  // Stop the thread
  //--------------------------------------------------------
  public synchronized void stop()
  {
    if (engine!=null)
    {
      options.hide();
      config.hide();
      pass.hide();
      engine.stop();
      engine = null;
      super.stop();
      System.out.println("Stop applet...");
      System.out.println("--------------");
    }
  }


  //--------------------------------------------------------
  // Run the thread => ACTION!
  //--------------------------------------------------------
  public void run()
  {
    int t1, t2, loadTime;
    Event event;

    m_status.setText(" ");
    clickedAbout();
    System.out.println("Run applet...");
    Thread me = Thread.currentThread();
    me.setPriority(Thread.MIN_PRIORITY);

    while(engine==me)
    {
      t1 = (int)System.currentTimeMillis();
      if (!showAbout)
      {
        if (!nextImageLoc())
        {
          continue;
        }
      }
      getNewImage();
      numOfLoaded++;

      if (!(imgError || showAbout))
      {
        paintOffScrGC(); //write to dubble buffer
        repaint();       // write to screen
      }

      t2 = (int)System.currentTimeMillis();
      loadTime = t2 - t1;
      msTimeLeft = interval - loadTime;
      msTimeLeft = (msTimeLeft<150) ? 150 : msTimeLeft;

      try
      {
        if (imgError)
        {
          nError++;
          m_status.setText("Fail in loading image " + (current+1) +" !");
        }
        else
        {
          while (msTimeLeft>100)
          {
            updateStatus("  Time-out: "+ ((msTimeLeft+500)/1000) + " s");
            engine.sleep((msTimeLeft<1000) ? msTimeLeft : 800); // timeout with 1 s or remaind time
            msTimeLeft -= 1000;   // countdown
          }
        }
      } catch (InterruptedException e)
        {
          System.out.println("[run()]"+e);
        }
      updateStatus(" ");
      System.out.println("[ "+nError+" | "+numOfLoaded+" | "+(current+1)+" | "+loadTime+" ]");
      System.gc();
    }
  }


  //--------------------------------------------------------
  // find the next location
  //--------------------------------------------------------
  public synchronized boolean nextImageLoc()
  {
    int oldLoc = current;

      // check if this one want to show
    do
    {
      current++;  // next image

        // keep the counter on track!
      if (current+1>amountOfImages)
      {
        current = 0;
      }
    } while (!(showStatus[current] || current==oldLoc));

    if (!showStatus[current])
    {
      m_status.setText("No image(s) selected!");
      return false;
    }
    else
    {
      return true;
    }
  }


  //--------------------------------------------------------
  // get a new image
  //--------------------------------------------------------
  public synchronized void getNewImage()
  {
    if (noRefresh)
    {
      if (!allLoaded)
      {
        getNewImageFromNet();
        if (!imgError)
        {
          imageBank.addElement(currentImage);
        }
        else
        {
          imageBank.addElement(null);
        }

        if (current+1==amountOfImages)
        {
          allLoaded = true;
        }
      }
      else
      {
        getAnImageFromBank();
      }
    }
    else
    {
      getNewImageFromNet();
    }
  }


  //--------------------------------------------------------
  // get a new image from bank
  //--------------------------------------------------------
  public synchronized void getAnImageFromBank()
  {
    currentImage = (Image)imageBank.elementAt(current);
    showAbout = false;
  }


  //--------------------------------------------------------
  // get a new image from net
  //--------------------------------------------------------
  public synchronized void getNewImageFromNet()
  {
    int loadTime, t1;
    MediaTracker mTracker = new MediaTracker(this);

    try
    {
      updateStatus("["+nError+"|"+numOfLoaded+"]"+"  Loading image ...      ");
      if (config.m_cgiParam.getState())
      {
        currentImage = getImage(codeBase, (String)imageList.elementAt(current)+config.cgiParamString);
      }
      else
      {
        currentImage = getImage(codeBase, (String)imageList.elementAt(current));
      }
      currentImage.flush();
      mTracker.addImage(currentImage, numOfLoaded);     // use for control of loading
      mTracker.checkID(numOfLoaded, true);
      loadTime = 0;
      loaded = false;
      showAbout = false;

      t1 = (int)System.currentTimeMillis();
      while (loadTime<maxLoadTime && !loaded && !showAbout)  // if stop-button not activated
      {
        loadTime = (int)System.currentTimeMillis() - t1;
        loaded = mTracker.checkID(numOfLoaded, true);
      }
      System.out.print("["+loadTime+"] ");

      if (!showAbout)
      {
        imgError = (mTracker.statusID(numOfLoaded, true)==MediaTracker.COMPLETE) ? false : true;
      }

      if (showAbout || imgError)
      {
        currentImage = null;
      }
    } catch(Exception e)
      {
    	System.out.println("[getNewImageFromNet()] "+e);
      }
    updateStatus(" ");
  }


  //--------------------------------------------------------
  // update image
  //--------------------------------------------------------
  public synchronized void update(Graphics g)
  {
    paint(g);
  }


  //--------------------------------------------------------
  // Update screen
  //--------------------------------------------------------
  public synchronized void paint(Graphics g)
  {
    g.drawImage(offScrImage, 0, 0, this);  //update screen;

      //enable button About after showing an image
    if (!showAbout)
    {
      m_about.enable();
    }
  }


  //--------------------------------------------------------
  // Update dubble buffer
  //--------------------------------------------------------
  public synchronized void paintOffScrGC()
  {
    int x=5, y=5, imWidth=0, imHeight=0, newWidth, newHeight;

    if (loaded && !showAbout && !imgError)
    {
      m_status.setText((String)imageLabels.elementAt(current));
      offScrGC.setColor(bgColor);
      offScrGC.fillRect(0, 0, frameWidth, frameHeight+30);

      while (imWidth<=0 || imHeight<=0)
      {
        imWidth = currentImage.getWidth(this);
        imHeight = currentImage.getHeight(this);
      }

      if (imgFitFrame)
      {
          // newWidth/newHeight = imWidth/imHeight
        newWidth  = frameWidth - 9;
        newHeight = (newWidth * imHeight / imWidth);
        if (newHeight>(frameHeight-9))
        {
          newHeight = frameHeight - 9;
          newWidth  = newHeight * imWidth / imHeight;
        }
        imWidth  = newWidth;
        imHeight = newHeight;
        x = (frameWidth  - imWidth)  / 2;
        y = (frameHeight - imHeight) / 2;
        offScrGC.drawImage(currentImage, x, y, imWidth, imHeight, this);
      }
      else
      {
        x = (frameWidth  - imWidth)  / 2;
        y = (frameHeight - imHeight) / 2;
        offScrGC.drawImage(currentImage, x, y, this);
      }

      imWidth  += 9;
      imHeight += 9;
      if (!noFrame)
      {
        x = (x-5<0) ? 5 : x;
        y = (y-5<0) ? 5 : y;

        imWidth  = (imWidth>frameWidth)   ? frameWidth  : imWidth;
        imHeight = (imHeight>frameHeight) ? frameHeight : imHeight;
        draw3DFrame(offScrGC, x-5, y-5, imWidth, imHeight);
      }
    }
  }


  //--------------------------------------------------------
  // update status
  //--------------------------------------------------------
  public synchronized void updateStatus(String inText)
  {
    if (inText != null)
    {
      statusText = inText;
    }

    if (!noStatusText)
    {
      this.showStatus(statusText);
    }
  }


  //--------------------------------------------------------
  // Catch events
  //--------------------------------------------------------
  public boolean handleEvent(Event event)
  {
    if (event.id == Event.ACTION_EVENT && event.target == m_about)
    {
      clickedAbout();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_option)
    {
      clickedOption();
      return true;
    }
    return super.handleEvent(event);
  }


  //--------------------------------------------------------
  // always overwrite browsers statusfield
  //--------------------------------------------------------
  public boolean mouseMove(Event ev, int x, int y)
  {
    updateStatus(null);
    return true;
  }


  //--------------------------------------------------------
  // What to do when button About activated
  //--------------------------------------------------------
  public void clickedAbout()
  {
      // to do: put event handler code here.
    showAbout = true;
    m_about.disable();
    m_status.setText(" ");

    int x, y;

    Font f0 = offScrGC.getFont();
    Font f1 = new Font("Courier New", Font.BOLD,  30);
    Font f2 = new Font("Courier New", Font.BOLD,  24);
    Font f3 = new Font("Courier New", Font.BOLD,  22);
    Font f4 = new Font("Courier New", Font.PLAIN, 14);
    Font f5 = new Font("Courier New", Font.BOLD,  34);

    FontMetrics fm0 = offScrGC.getFontMetrics(f0);
    FontMetrics fm1 = offScrGC.getFontMetrics(f1);
    FontMetrics fm2 = offScrGC.getFontMetrics(f2);
    FontMetrics fm3 = offScrGC.getFontMetrics(f3);
    FontMetrics fm4 = offScrGC.getFontMetrics(f4);
    FontMetrics fm5 = offScrGC.getFontMetrics(f5);

    String t6 = binaryFile;
    String t7 = version;
    String t8 = "Copyright  1996-1997 Axis Communications AB ";
    String t5 = "Email: neteye@axis.com";

    offScrGC.setColor(bgColor);
    offScrGC.fillRect(0, 0, frameWidth, frameHeight);

    offScrGC.setColor(Color.lightGray);
    offScrGC.drawRoundRect(0, 0, frameWidth,   frameHeight,   25, 25);
    offScrGC.drawRoundRect(1, 1, frameWidth-2, frameHeight-2, 25, 25);

    y = frameHeight/2 - 120;
    y = y<0 ? 0 : y;
    x = (frameWidth - axislogo1.getWidth(this)) / 2;
    offScrGC.drawImage(axislogo1, x, y, this);
    x = (frameWidth - axislogo2.getWidth(this)) / 2;
    offScrGC.drawImage(axislogo2, x, y, this);

    offScrGC.setFont(f2);
    offScrGC.setColor(Color.blue);
    x = (frameWidth - fm2.stringWidth(t6)) / 2;
    offScrGC.drawString(t6, x, (y+=90));

    offScrGC.setFont(f3);
    x = (frameWidth - fm3.stringWidth(t7)) / 2;
    offScrGC.setColor(Color.black);
    offScrGC.drawString(t7, x+3, (y+=42));

    offScrGC.setFont(f4);
    offScrGC.setColor(Color.gray);
    offScrGC.drawLine(30, (y+=30), frameWidth-31, y);
    offScrGC.drawLine(30, y-2,     frameWidth-31, y-2);

    x = (frameWidth - fm4.stringWidth(t8)) / 2;
    offScrGC.setColor(Color.black);
    offScrGC.drawString(t8, x+3, y+=30);

    x = (frameWidth - fm4.stringWidth(t5)) / 2;
    offScrGC.setColor(Color.blue);
    offScrGC.drawString(t5, x+3, y+=30);

    repaint();
  }


  //--------------------------------------------------------
  // What to do when button Option activated
  //--------------------------------------------------------
  public void clickedOption()
  {
      // to do: put event handler code here.
    m_option.disable();
    options.show();
  }


  //--------------------------------------------------------
  // Show password frame
  //--------------------------------------------------------
  public void showPasswordFrame()
  {
    options.hide();
    config.hide();
    pass.show();
  }


  //--------------------------------------------------------
  // What to do when button OK in Password activated
  //--------------------------------------------------------
  public void clickedPassFrameOk()
  {
    switch (actionType)
    {
      case RELAY_ACTION:
        options.show();
        relayAction();
        break;
      case CONFIG_GET:
        clickOptionsConfig();
        break;
    }
  }


  //--------------------------------------------------------
  // What to do when button OK in Password activated
  //--------------------------------------------------------
  public void clickedPassFrameCancel()
  {
    options.show();
  }


  //--------------------------------------------------------
  // What to do when button Relay in Option menu activated
  //--------------------------------------------------------
  public void relayAction()
  {
    actionType = RELAY_ACTION;
    setLabelRelay();
    RelayActions relayActions = new RelayActions(this);
    relayActions.start();
  }


  //--------------------------------------------------------
  // What to do when button Config in Option menu activated
  //--------------------------------------------------------
  public void clickOptionsConfig()
  {
    options.hide();
    config.show();
  }


  //--------------------------------------------------------
  // enable/diable button Relay in Options
  //--------------------------------------------------------
  public void setLabelRelay()
  {
    String label;

    label = relayWillOn ? "Relay Off" : "Relay On";
    options.setLabelButtonRelay(label);

    if (relayAuto && relayWillOn)
    {
      options.disableButtonRelay();
    }
    else
    {
      options.enableButtonRelay();
    }
  }


  //--------------------------------------------------------
  // Sending a request
  //--------------------------------------------------------
  public boolean sendRequest(String textURL) throws IOException
  {
    Socket socket;
    String st1 = "", st2 = "", string;
    StringTokenizer token;

    socket = null;
    socket = connect(textURL);
    try
    {
      indata = sendGET();
    } finally
      {
        socket.close();
      }

    token = new StringTokenizer(indata, "\n");
    string = token.nextToken();
    string = token.nextToken();
    string = token.nextToken();
    if (string.length()>35)
    {
      System.out.println(string.substring(23, 35));
      return false;
    }
    else
    {
      string = token.nextToken();
      System.out.println(string);
      return true;
    }
  }


  //--------------------------------------------------------
  //Make a socket connection
  //--------------------------------------------------------
  public Socket connect(String textURL) throws MalformedURLException, IOException
  {
    URL url;
    Socket socket;

    url    = new URL (codeBase, textURL);
    file   = url.getFile ();
    socket = new Socket(url.getHost(), url.getPort()==-1?80:url.getPort());

    out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    in  = new DataInputStream(socket.getInputStream());

    return socket;
  }


  //--------------------------------------------------------
  // use metod GET
  //--------------------------------------------------------
  public String sendGET() throws IOException
  {
    String string, input;

    string = encodeBase64(userName + ":" + password);
    string = "GET " + file + " HTTP/1.0 Authorization: Basic "+ string + "\r\n\r\n";
    out.writeBytes(string);
    out.flush ();

    string = "";
    while ((input = in.readLine ()) != null)
    {
      string += input + "\n";
    }
    return string;
  }


  //--------------------------------------------------------
  // Base64 encoder
  //--------------------------------------------------------
  public String encodeBase64(String inString)
  {
    String baseTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    String encodeString = "";

    int c, m = -1, n = 0, p, i, j;
    long val=0;
    int enc[] = new int[4];

    j = inString.length();
    while (++m<j)
    {
      c = inString.charAt(m);

      if (n++<=2)
      {
        val <<= 8;
        val += c;
        continue;
      }
      for (i=0; i<4; i++)
      {
        enc[i] = (int)val & 63;
        val >>= 6;
      }
      for (i=3; i>=0; i--)
      {
        encodeString += baseTable.charAt(enc[i]);
        n = 1;
        val = c;
      }
    }
	if (n==2)
	{
      val <<= 8;
      for (i=0; i<4; i++)
      {
        enc[i] = (int)val & 63;
        val >>= 6;
      }
      enc[0] = 64;
	}
	if (n == 3)
	{
      for (i=0; i<4; i++)
      {
        enc[i] = (int)val & 63;
        val >>= 6;
	  }
	}
	if (n!=0)
	{
      for (i=3; i>=0; i--)
      {
        encodeString += baseTable.charAt(enc[i]);
      }
	}
    return encodeString;
  }
}

