// File Name:   RelayActions.java
//
// Description: Thread for relay function
//-----------------------------------------------------------------------------
// History
//
// Date   Name           Changes  option
// ----   ----           -------
// 970130 Le Chi Kiet    --
// ****************************************************************************
//   Copyright 1996-1997 Axis communications AB, Lund, SWEDEN
//  All rights reserved.


class RelayActions extends Thread
{
  private campict thisApplet;
  private boolean unauthorized = false;
  private String relayOn  = "../io/relayon.txt";
  private String relayOff = "../io/relayoff.txt";


  //--------------------------------------------------------
  // Init
  //--------------------------------------------------------
  public RelayActions(campict app)
  {
    super();
    thisApplet = app;
  }


  //--------------------------------------------------------
  // Action!
  //--------------------------------------------------------
  public void run()
  {
    boolean ok;

    setPriority(Thread.MIN_PRIORITY);
    try
    {
      ok = setRelayOnOff();

      if (thisApplet.relayAuto && ok)
      {
        sleep(thisApplet.relayOnDelays);
        setRelayOnOff();
      }

    } catch(Exception e)
      {
    	System.out.println("[run()] "+e);
      }
  }


  //--------------------------------------------------------
  // switch off the relay
  //--------------------------------------------------------
  public boolean setRelayOnOff() throws Exception
  {
    boolean ok = true;

    thisApplet.setLabelRelay();
    ok = thisApplet.relayWillOn ? setRelayOn() : setRelayOff();

    if (!ok)
    {
      thisApplet.showPasswordFrame();
    }

    return ok;
  }


  //--------------------------------------------------------
  // switch on the relay
  //--------------------------------------------------------
  public boolean setRelayOn() throws Exception
  {
    boolean ok = thisApplet.sendRequest(relayOn);
    thisApplet.relayWillOn  = !ok;
    return ok;
  }


  //--------------------------------------------------------
  // What to do when button RelayOff i Option menu activated
  //--------------------------------------------------------
  public boolean setRelayOff() throws Exception
  {
    boolean ok = thisApplet.sendRequest(relayOff);
    thisApplet.relayWillOn  = ok;
    return ok;
  }
}
