// File Name:   PassFrame.java
//
// Description: Password frame
//-----------------------------------------------------------------------------
// History
//
// Date   Name           Changes  option
// ----   ----           -------
// 970130 Le Chi Kiet    --
// ****************************************************************************
//   Copyright 1996-1997 Axis communications AB, Lund, SWEDEN
//  All rights reserved.

import java.awt.*;


public class PassFrame extends Frame
{
  //{{DECLARE_CONTROLS
  //}}

  private campict thisApplet;
  private int frameWidth  = 330;
  private int frameHeight = 240;
  private Label m_passLabel1, m_passLabel2, m_passLabel3;
  private TextField m_userName, m_password;
  private Button m_passOk, m_passCancel;


  //--------------------------------------------------------
  // Init
  //--------------------------------------------------------
  public PassFrame(campict ap)
  {
    super("Authentication");
    thisApplet = ap;

    //{{INIT_CONTROLS
    //}}
    int i, j, current;
    int x, y;

    setBackground(Color.lightGray);
    setLayout(null);
    addNotify();
    resize(insets().left + insets().right + frameWidth, insets().top + insets().bottom + frameHeight);

    x = 20;
    y = 30 + insets().top;
    setBackground(Color.lightGray);
    setLayout(null);
    addNotify();
    resize(insets().left + insets().right + frameWidth, insets().top + insets().bottom + frameHeight);

    m_passLabel1 = new Label("Please enter your authentication information.", Label.CENTER);
    m_passLabel1.reshape(0, y, frameWidth, 17);
    add(m_passLabel1);

    m_passLabel2 = new Label("User name:", Label.RIGHT);
    m_passLabel2.reshape(x, y+=50, 100, 17);
    add(m_passLabel2);
    m_userName = new TextField(thisApplet.userName);
    m_userName.reshape(x+110, y-3, 150, 22);
    add(m_userName);

    m_passLabel3 = new Label("Password:", Label.RIGHT);
    m_passLabel3.reshape(x, y+=40, 100, 17);
    add(m_passLabel3);
    m_password = new TextField(thisApplet.password);
    m_password.reshape(x+110, y-3, 150, 22);
    m_password.setEchoCharacter('*');
    add(m_password);

    x = 105;
    y = 185 + insets().top;
    m_passOk = new Button("OK");
    m_passOk.reshape(x, y, 55, 23);
    add(m_passOk);
    m_passCancel = new Button("Cancel");
    m_passCancel.reshape(x+=65, y, 55, 23);
    add(m_passCancel);
  }


  //--------------------------------------------------------
  // show the frame
  //--------------------------------------------------------
  public synchronized void show()
  {
  	move(thisApplet.framePos.x, thisApplet.framePos.y);
  	super.show();
    m_userName.requestFocus();
    m_userName.selectAll();
  }


  //--------------------------------------------------------
  // hide the frame
  //--------------------------------------------------------
  public synchronized void hide()
  {
  	thisApplet.framePos = location();
  	super.hide();
  }


  //--------------------------------------------------------
  // Catch events
  //--------------------------------------------------------
  public boolean handleEvent(Event event)
  {
    if (event.id == Event.WINDOW_DESTROY)
    {
      clickedPassCancel();
      return true;
    }
    else if (event.id == Event.KEY_RELEASE && event.target == m_userName)
    {
      keyReleaseUserName(event);
      return true;
    }
    else if (event.id == Event.KEY_RELEASE && event.target == m_password)
    {
      keyReleasePassword(event);
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_passOk)
    {
      clickedPassOk(event);
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_passCancel)
    {
      clickedPassCancel();
      return true;
    }
    return super.handleEvent(event);
  }


  //--------------------------------------------------------
  // what to do when key release from userName-editbox
  //--------------------------------------------------------
  private synchronized void keyReleaseUserName(Event ev)
  {
    if (ev.key == '\n')  //if input = 'Enter'
    {
      m_password.requestFocus();
      m_password.selectAll();
    }
  }


  //--------------------------------------------------------
  // what to do when key release from password-editbox
  //--------------------------------------------------------
  private synchronized void keyReleasePassword(Event ev)
  {
    if (ev.key == '\n')  //if input = 'Enter'
    {
      m_passOk.requestFocus();
      clickedPassOk(null);
    }
  }


  //--------------------------------------------------------
  // What to do when button Ok i password menu activated
  //--------------------------------------------------------
  private synchronized void clickedPassOk(Event ev)
  {
      // to do: put event handler code here.
    hide();
    thisApplet.userName = m_userName.getText();
    thisApplet.password = m_password.getText();
    thisApplet.clickedPassFrameOk();
  }


  //--------------------------------------------------------
  // What to do when button Cancel i password menu activated
  //--------------------------------------------------------
  private synchronized void clickedPassCancel()
  {
      // to do: put event handler code here.
    hide();
    thisApplet.clickedPassFrameCancel();
  }


}


