// File Name:   OptionFrame.java
//
// Description: 'Options' frame
//-----------------------------------------------------------------------------
// History
//
// Date   Name           Changes  option
// ----   ----           -------
// 970130 Le Chi Kiet    A standalone window for Options.
//                       Change button 'OpenDoor' to 'RelayOn'
// ****************************************************************************
//   Copyright 1996-1997 Axis communications AB, Lund, SWEDEN
//  All rights reserved.

import java.awt.*;
import java.net.*;


public class OptionFrame extends Frame
{
  //{{DECLARE_CONTROLS
  //}}

  private campict thisApplet;
  private int frameWidth  = 330;
  private int frameHeight = 240;
  private Button m_goTo, m_ok, m_cancel, m_next, m_prev;
  private Button m_relay, m_apply, m_config;
  private Checkbox check[];

  private Label m_labelInterval, m_labelDoorDelay;
  private Label m_label2, m_label3, m_label4;
  private TextField m_interval, m_relayOnDelays;
  private Checkbox m_imgFitFrame, m_noFrame;
  private int checkList[][],  checkListNumber=0, maxShowCheck=3;


  //--------------------------------------------------------
  // Init
  //--------------------------------------------------------
  public OptionFrame(campict ap)
  {
    super("Options");
    thisApplet = ap;

    //{{INIT_CONTROLS
    //}}
    int i, j, current;
    int x, y;

    setBackground(Color.lightGray);
    setLayout(null);
    addNotify();
    resize(insets().left + insets().right + frameWidth, insets().top + insets().bottom + frameHeight);

    x = 30;
    y = 15 + insets().top;

    m_relay = new Button("Relay On");
    m_relay.reshape(x-20, y, 75 ,25);
    add(m_relay);
    if (thisApplet.relayOnDelays==0)
    {
      m_relay.disable();
    }

    m_goTo = new Button("Homepage of Campict");
    m_goTo.reshape(x+60, y, 160, 25);
    add(m_goTo);

    m_config = new Button("Config");
    m_config.reshape(x+225, y, 75, 25);
    add(m_config);
    m_config.enable(thisApplet.imgConfig);

    m_labelDoorDelay = new Label("RelayOn delays (s):", Label.RIGHT);
    m_labelDoorDelay.reshape(x-=40, y+=43, 153, 19);
    add(m_labelDoorDelay);
    m_relayOnDelays = new TextField(Integer.toString((int)(thisApplet.relayOnDelays/1000)));
    m_relayOnDelays.reshape(x+155, y-3, 30, 22);
    add(m_relayOnDelays);
    if (thisApplet.relayOnDelays==0)
    {
      m_relayOnDelays.disable();
    }

    m_labelInterval = new Label("Loading interval (s):", Label.RIGHT);
    m_labelInterval.reshape(x, y+=26, 153, 19);
    add(m_labelInterval);
    m_interval = new TextField(Integer.toString((int)thisApplet.interval/1000));
    m_interval.reshape(x+=155, y-3, 30, 22);
    add(m_interval);

    m_noFrame = new Checkbox("No frame");
    m_noFrame.reshape(x+=40, y-=23, 150, 19);
    add(m_noFrame);
    m_noFrame.setState(thisApplet.noFrame);

    m_imgFitFrame = new Checkbox("Fit image to frame");
    m_imgFitFrame.reshape(x, y+=20, 150, 19);
    add(m_imgFitFrame);
    m_imgFitFrame.setState(thisApplet.imgFitFrame);

    m_label4 = new Label("Choose Image(s) ["+thisApplet.amountOfImages+"]:");
    m_label4.reshape(x=10, y+=33, 191, 19);
    add(m_label4);

    x = 15;
    y = 205 + insets().top;
    m_ok = new Button("OK");
    m_ok.reshape(x, y, 55, 23);
    add(m_ok);
    m_cancel = new Button("Cancel");
    m_cancel.reshape(x+=63, y, 55, 23);
    add(m_cancel);
    m_prev = new Button("<");
    m_prev.reshape(x+=63, y, 55, 23);
    add(m_prev);
    m_next = new Button(">");
    m_next.reshape(x+=63, y, 55, 23);
    add(m_next);
    m_apply = new Button("Apply");
    m_apply.reshape(x+=63, y, 55, 23);
    add(m_apply);

    check      = new Checkbox[thisApplet.amountOfImages];
    thisApplet.showStatus = new boolean[thisApplet.amountOfImages];
    int nGrp   = (int)Math.ceil(((double)thisApplet.amountOfImages)/((double)maxShowCheck));
    checkList  = new int[nGrp][4];
    current    = 0;

    x = 25;
    y = 137 + insets().top;
    for (i=0; i<nGrp; i++)
    {
      if (i==0)
      {
        checkList[0][0] = 0;  //first list's has no prev
      }
      else
      {
        checkList[i-1][3] = 1;       //prev list has next
        checkList[i][0]   = 1;       //this list has prev
        checkList[i][1]   = current; //first IMAGE in this list
      }
      for (j=0; j<maxShowCheck && current<thisApplet.amountOfImages; j++, current++)
      {
        check[current] = new Checkbox((String)thisApplet.imageLabels.elementAt(current));
        check[current].reshape(x, y+j*20, 225, 19);
        check[current].setState(true);
        thisApplet.showStatus[current] = check[current].getState();
      }
      checkList[i][2] = current-1;  //last image in this list
      checkList[i][3] = 0;       //this list has no next
    }
    if (thisApplet.imgDefault)
    {
        // only check fullsize.jpg
      for (i=1; i<thisApplet.amountOfImages; i++)
      {
        check[i].setState(false);  //uncheck halfsize.jpg
        thisApplet.showStatus[i] = check[i].getState();
      }
    }
    addCheckBoxes();
  }


  //--------------------------------------------------------
  // add checkboxes to optionsmenu
  //--------------------------------------------------------
  private void addCheckBoxes()
  {
    if (checkList[checkListNumber][0]==1)
    {
      m_prev.enable();
    }
    else
    {
      m_prev.disable();
    }

    if (checkList[checkListNumber][3]==1)
    {
      m_next.enable();
    }
    else
    {
      m_next.disable();
    }

    for (int i=checkList[checkListNumber][1]; i<=checkList[checkListNumber][2]; i++)
    {
      add(check[i]);
    }
  }


  //--------------------------------------------------------
  // remove checkboxes to optionsmenu
  //--------------------------------------------------------
  private void removeCheckBoxes()
  {
    for (int i=checkList[checkListNumber][1]; i<=checkList[checkListNumber][2]; i++)
    {
      remove(check[i]);
    }
  }


  //--------------------------------------------------------
  // show the frame
  //--------------------------------------------------------
  public synchronized void show()
  {
  	move(thisApplet.framePos.x, thisApplet.framePos.y);
  	super.show();
    m_apply.disable();
  	requestFocus();
  }


  //--------------------------------------------------------
  // hide the frame
  //--------------------------------------------------------
  public synchronized void hide()
  {
  	thisApplet.framePos = location();
  	super.hide();
  }


  //--------------------------------------------------------
  // Enable button 'Relay'
  //--------------------------------------------------------
  public synchronized void enableButtonRelay()
  {
    m_relay.enable();
  }


  //--------------------------------------------------------
  // Disable button 'Relay'
  //--------------------------------------------------------
  public synchronized void disableButtonRelay()
  {
    m_relay.disable();
  }


  //--------------------------------------------------------
  // Disable button 'Relay'
  //--------------------------------------------------------
  public synchronized void setLabelButtonRelay(String label)
  {
    m_relay.setLabel(label);
  }


  //--------------------------------------------------------
  // Catch events
  //--------------------------------------------------------
  public boolean handleEvent(Event event)
  {
    if (    (event.target instanceof Checkbox)
         || (event.target instanceof TextField) )
    {
      if (event.target != m_relayOnDelays)
      {
        m_apply.enable();
      }
    }

    if (event.id == Event.WINDOW_DESTROY)
    {
      clickedCancel();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_config)
    {
      clickedConfig();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_relay)
    {
      clickedRelayOnOff();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_goTo)
    {
      clickedGoTo();
      return true;
    }
    else if (event.id == Event.KEY_RELEASE && event.target == m_relayOnDelays)
    {
      keyReleaseDoorDelay(event);
      return true;
    }
    else if (event.id == Event.KEY_RELEASE && event.target == m_interval)
    {
      keyReleaseInterval(event);
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_ok)
    {
      clickedOk(event);
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_cancel)
    {
      clickedCancel();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_next)
    {
      clickedNext();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_prev)
    {
      clickedPrev();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_apply)
    {
      clickedApply(event);
      return true;
    }
    return super.handleEvent(event);
  }


  //--------------------------------------------------------
  // What to do when button Go To i Option menu activated
  //--------------------------------------------------------
  private void clickedGoTo()
  {
    clickedCancel();
    try
    {
      URL url = new URL(thisApplet.codeBase, thisApplet.homeLink);
      thisApplet.getAppletContext().showDocument(url);
    } catch (MalformedURLException ex)
      {
        thisApplet.m_status.setText("...");
      }
  }


  //--------------------------------------------------------
  // what to do when key release from interval-editbox
  //--------------------------------------------------------
  private synchronized boolean keyReleaseDoorDelay(Event ev)
  {
      // to do: put event handler code here.
    int intTmp;

    if (ev.key == '\n')  //if input = 'Enter'
    {
      m_relay.requestFocus();
    }
    try
    {
      intTmp = Integer.parseInt(m_relayOnDelays.getText())*1000;
    } catch (NumberFormatException e)
      {
        System.out.println("[keyReleaseDoorDelay()] "+e);
        return false;
      }
    if (thisApplet.relayOnDelays!=intTmp)
    {
      System.out.println("New OpenDoor delay time!");
      thisApplet.relayOnDelays = intTmp;
    }
    return true;
  }


  //--------------------------------------------------------
  // what to do when key release from interval-editbox
  //--------------------------------------------------------
  private synchronized boolean keyReleaseInterval(Event ev)
  {
      // to do: put event handler code here.
    int intTmp;

    if (ev.key == '\n')  //if input = 'Enter'
    {
      try
      {
        intTmp = Integer.parseInt(m_interval.getText())*1000;
      } catch (NumberFormatException e)
        {
          System.out.println("[keyReleaseInterval()] "+e);
          return false;
        }
      m_ok.requestFocus();
      if (thisApplet.interval!=intTmp)
//      if (!(thisApplet.interval==intTmp || thisApplet.standby))
      {
        System.out.println("New Interval!");
      }
    }
    return true;
  }


  //--------------------------------------------------------
  // What to do when button ">" (Next) i OptionMenu activated
  //--------------------------------------------------------
  private void clickedNext()
  {
    removeCheckBoxes();
    checkListNumber++;
    addCheckBoxes();
  }


  //--------------------------------------------------------
  // What to do when button "<" (Prev) i OptionMenu activated
  //--------------------------------------------------------
  private void clickedPrev()
  {
    removeCheckBoxes();
    checkListNumber--;
    addCheckBoxes();
  }


  //--------------------------------------------------------
  // What to do when button OK i Option menu activated
  //--------------------------------------------------------
  private void clickedApply(Event ev)
  {
      // to do: put event handler code here.
    if (m_apply.isEnabled())
    {
      m_apply.disable();
      thisApplet.imgFitFrame = m_imgFitFrame.getState();
      thisApplet.noFrame     = m_noFrame.getState();

      for (int i=0; i<thisApplet.amountOfImages; i++)
      {
        thisApplet.showStatus[i] = check[i].getState();
      }

        //read Interval
      ev.key = '\n';
      thisApplet.interval      = keyReleaseInterval(ev) ?
                               Integer.parseInt(m_interval.getText())*1000 :
                               thisApplet.interval;
      thisApplet.relayOnDelays = keyReleaseDoorDelay(ev) ?
                               Integer.parseInt(m_relayOnDelays.getText())*1000 :
                               thisApplet.relayOnDelays;
      thisApplet.msTimeLeft = 0;
      thisApplet.loaded = true;
    }
  }


  //--------------------------------------------------------
  // What to do when button Cancel i Option menu activated
  //--------------------------------------------------------
  private void clickedCancel()
  {
      // to do: put event handler code here.
    hide();
    removeCheckBoxes();

    m_imgFitFrame.setState(thisApplet.imgFitFrame);
    m_noFrame.setState(thisApplet.noFrame);
    m_interval.setText(Integer.toString(thisApplet.interval/1000));
    for (int i=0; i<thisApplet.amountOfImages; i++)
    {
      check[i].setState(thisApplet.showStatus[i]);
    }

    checkListNumber = 0;
    addCheckBoxes();
    thisApplet.m_option.enable();
  }


  //--------------------------------------------------------
  // What to do when button OK i Option menu activated
  //--------------------------------------------------------
  private void clickedOk(Event ev)
  {
    clickedApply(ev);
    clickedCancel();
  }


  //--------------------------------------------------------
  // What to do when button Relay i Option menu activated
  //--------------------------------------------------------
  private void clickedRelayOnOff()
  {
    thisApplet.relayAction();
  }


  //--------------------------------------------------------
  // What to do when button Config i Option menu activated
  //--------------------------------------------------------
  private void clickedConfig()
  {
    thisApplet.clickOptionsConfig();
  }

}


