// File Name:   GetParameters.java
//
// Description:
//-----------------------------------------------------------------------------
// History
//
// Date   Name           Ver        Changes  option
// ----   ----           ---        -------
// 970317 Le Chi Kiet    1.xx       --
// ****************************************************************************
//   Copyright 1997 Axis communications AB, Lund, SWEDEN
//  All rights reserved.

import java.awt.*;
import java.applet.Applet;

public class MyApplet extends Applet
{

  //------------------------------------------------------------------------
  //  get string param from html-file
  //------------------------------------------------------------------------
  public synchronized String getParam(String param)
  {
    return(getParameter(param));
  }


  //------------------------------------------------------------------------
  //  get string param from html-file
  //------------------------------------------------------------------------
  public synchronized String getParam(String param, String defaultString)
  {
    String string;

    string = getParameter(param);
    if (string!=null)
    {
      return (string);
    }
    else
    {
      return defaultString;
    }
  }


  //------------------------------------------------------------------------
  //  get color param from html-file
  //------------------------------------------------------------------------
  public synchronized Color getParam(String param, Color defaultColor)
  {
    String string;

    string = getParameter(param);
    if (   string!=null
        && string.length()==7
        && string.charAt(0)=='#')
    {
      return (new Color(Integer.parseInt(string.substring(1,7),16)));
    }
    return defaultColor;
  }


  //------------------------------------------------------------------------
  //  get boolean param from html-file
  //------------------------------------------------------------------------
  public synchronized boolean getParam(String param, boolean defaultBoolean)
  {
    String string;

    string = getParameter(param);
    return ((string==null) ? defaultBoolean : Boolean.valueOf(string).booleanValue());
  }


  //------------------------------------------------------------------------
  //  get int param from html-file
  //------------------------------------------------------------------------
  public synchronized int getParam(String param, int defaultInt)
  {
    String string;

    string = getParameter(param);
    return ((string==null) ? defaultInt : Integer.parseInt(string));
  }


  //------------------------------------------------------------------------
  //  get int param from html-file
  //------------------------------------------------------------------------
  public synchronized float getParam(String param, float defaultFloat)
  {
    String string;

    string = getParameter(param);
    return ((string==null) ? defaultFloat : Float.valueOf(string).floatValue());
  }


  //--------------------------------------------------------
  // What to do when button Option activated
  //--------------------------------------------------------
  public synchronized void draw3DFrame(Graphics g, int x, int y, int width, int height)
  {
      //create 3-D frame
    g.setColor(Color.white);
    g.drawRect(x+1, y+1, width-2, height-2);
    g.drawRect(x+4, y+4, width-8, height-8);

    g.setColor(Color.lightGray);
    g.drawRect(x,   y,   width,   height);
    g.drawRect(x+2, y+2, width-4, height-4);
    g.drawRect(x+3, y+3, width-6, height-6);

    g.setColor(Color.gray);
    g.drawLine(x+1, y+height-1, x+width-1, y+height-1);
    g.drawLine(x+width-1, y+1,  x+width-1, y+height-1);

    g.drawLine(x+4, y+4, x+4,       y+height-5);
    g.drawLine(x+4, y+4, x+width-5, y+4);

    g.setColor(Color.black);
    g.drawLine(x, y+height, x+width, y+height);
    g.drawLine(x+width,  y, x+width, y+height);
  }
}
