// File Name:   ConfigFrame.java
//
// Description: 'Config' frame
//-----------------------------------------------------------------------------
// History
//
// Date   Name           Changes  option
// ----   ----           -------
// 970406 Le Chi Kiet    A standalone window for Image Configuration.
// ****************************************************************************
//   Copyright 1996-1997 Axis communications AB, Lund, SWEDEN
//  All rights reserved.

import java.awt.*;
import java.util.*;
import java.net.*;


public class ConfigFrame extends Frame
{
  //{{DECLARE_CONTROLS
  //}}

  private campict thisApplet;
  private int frameWidth  = 330;
  private int frameHeight = 240;

  private Button m_ok, m_help;
  private Label  m_labelMirror, m_labelRotation, m_labelColor;
  private Label  m_labelComp, m_labelDarkDetect;
  private Label  m_labelLogo, m_labelClock;

  private Choice m_mirror, m_rotation, m_color, m_comp;
  private Choice m_darkDetect, m_logo, m_clock;

  public  Checkbox m_cgiParam;
  public  String cgiParamString = "";

  private Hashtable config;


  //--------------------------------------------------------
  // Init
  //--------------------------------------------------------
  public ConfigFrame(campict ap)
  {
    super("Configuration - Image");
    thisApplet = ap;

    //{{INIT_CONTROLS
    //}}
    int i, j, current;
    int x, y, z, cw;

    setBackground(Color.lightGray);
    setLayout(null);
    addNotify();
    resize(insets().left + insets().right + frameWidth, insets().top + insets().bottom + frameHeight);

    x = 5;
    y = 15 + insets().top;
    z = 26;
    cw = 84;

    m_labelComp = new Label("Compression:", Label.RIGHT);
    m_labelComp.reshape(x, y, 120, 19);
    add(m_labelComp);
    m_comp = new Choice();
    add(m_comp);
    m_comp.reshape(x+125, y, cw, 19);
    m_comp.addItem("Low");
    m_comp.addItem("Medium");
    m_comp.addItem("High");

    m_labelColor = new Label("Color:", Label.RIGHT);
    m_labelColor.reshape(x, y+=z, 120, 19);
    add(m_labelColor);
    m_color = new Choice();
    add(m_color);
    m_color.reshape(x+125, y, cw, 19);
    m_color.addItem("Normal");
    m_color.addItem("Less");
    m_color.addItem("None");

    m_labelDarkDetect = new Label("Dark Detect:", Label.RIGHT);
    m_labelDarkDetect.reshape(x, y+=z, 120, 19);
    add(m_labelDarkDetect);
    m_darkDetect = new Choice();
    add(m_darkDetect);
    m_darkDetect.reshape(x+125, y, cw, 19);
    m_darkDetect.addItem("Off");
    m_darkDetect.addItem("On");

    m_labelLogo = new Label("Axislogo:", Label.RIGHT);
    m_labelLogo.reshape(x, y+=z, 120, 19);
    add(m_labelLogo);
    m_logo = new Choice();
    add(m_logo);
    m_logo.reshape(x+125, y, cw, 19);
    m_logo.addItem("Off");
    m_logo.addItem("On");

    m_labelClock = new Label("Clock:", Label.RIGHT);
    m_labelClock.reshape(x, y+=z, 120, 19);
    add(m_labelClock);
    m_clock = new Choice();
    add(m_clock);
    m_clock.reshape(x+125, y, cw, 19);
    m_clock.addItem("Off");
    m_clock.addItem("On");

    m_labelRotation = new Label("Rotation:", Label.RIGHT);
    m_labelRotation.reshape(x, y+=z, 120, 19);
    add(m_labelRotation);
    m_rotation = new Choice();
    add(m_rotation);
    m_rotation.reshape(x+125, y, cw, 19);
    m_rotation.addItem("Normal");
    m_rotation.addItem("Upsidedown");
    m_rotation.addItem("90 deg");
    m_rotation.addItem("270 deg");

    m_labelMirror=new Label("Mirror:", Label.RIGHT);
    m_labelMirror.reshape(x, y+=z, 120, 19);
    add(m_labelMirror);
    m_mirror = new Choice();
    add(m_mirror);
    m_mirror.reshape(x+125, y, cw, 19);
    m_mirror.addItem("Off");
    m_mirror.addItem("On");

    m_cgiParam = new Checkbox("Apply CGI-parameters");
    m_cgiParam.reshape(15, 205+insets().top, 150, 19);
    add(m_cgiParam);

    x = frameWidth - 70;
    y = 175 + insets().top;

    m_ok = new Button("OK");
    m_ok.reshape(x, y, 55, 23);
    add(m_ok);

    m_help = new Button("Help");
    m_help.reshape(x, y+=30, 55, 23);
    add(m_help);

    disableAll();
    config = new Hashtable();
    param2Hashtable();
  }


  //--------------------------------------------------------
  // Disable all choiceboxes
  //--------------------------------------------------------
  private void disableAll()
  {
    m_comp.disable();
    m_color.disable();
    m_darkDetect.disable();
    m_logo.disable();
    m_clock.disable();
    m_rotation.disable();
    m_mirror.disable();
  }


  //--------------------------------------------------------
  // Enable all choiceboxes
  //--------------------------------------------------------
  private void enableAll()
  {
    m_comp.enable();
    m_color.enable();
    m_darkDetect.enable();
    m_logo.enable();
    m_clock.enable();
    m_rotation.enable();
    m_mirror.enable();
  }


  //--------------------------------------------------------
  // show the frame
  //--------------------------------------------------------
  public synchronized void show()
  {
  	move(thisApplet.framePos.x, thisApplet.framePos.y);
  	super.show();
  	requestFocus();
  }


  //--------------------------------------------------------
  // hide the frame
  //--------------------------------------------------------
  public synchronized void hide()
  {
  	thisApplet.framePos = location();
  	super.hide();
  }


  //--------------------------------------------------------
  // Catch events
  //--------------------------------------------------------
  public boolean handleEvent(Event event)
  {
    if (event.target instanceof Choice)
    {
      param2Hashtable();
    }

    if (event.id == Event.WINDOW_DESTROY)
    {
      hide();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_ok)
    {
      clickedOk();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_cgiParam)
    {
      clickedCgiParam();
      return true;
    }
    else if (event.id == Event.ACTION_EVENT && event.target == m_help)
    {
      clickedHelp();
      return true;
    }
    return super.handleEvent(event);
  }


  //--------------------------------------------------------
  // What to do when button OK i Config menu activated
  //--------------------------------------------------------
  private void clickedOk()
  {
    param2Hashtable();
    hide();
    thisApplet.m_option.enable();
  }


  //--------------------------------------------------------
  // What to do when button OK i Config menu activated
  //--------------------------------------------------------
  private void clickedCgiParam()
  {
    if (m_cgiParam.getState())
    {
      enableAll();
    }
    else
    {
      disableAll();
    }
  }


  //--------------------------------------------------------
  // What to do when button Help activated
  //--------------------------------------------------------
  private void clickedHelp()
  {
    hide();
    thisApplet.m_option.enable();
    try
    {
      URL url = new URL(thisApplet.codeBase, thisApplet.imageHelpLink);
      thisApplet.getAppletContext().showDocument(url);
    } catch (MalformedURLException ex)
      {
        thisApplet.m_status.setText("...");
      }
  }


  //--------------------------------------------------------
  // parser Param to string
  //--------------------------------------------------------
  private void param2String()
  {
    String string;

    string  = "?" + "Compression"  + (String)config.get("Compression");
    string += "&" + "Color="       + (String)config.get("Color");
    string += "&" + "Axislogo="    + (String)config.get("Axislogo");
    string += "&" + "Clock="       + (String)config.get("Clock");
    string += "&" + "Dark Detect=" + (String)config.get("Dark Detect");
    string += "&" + "Rotation="    + (String)config.get("Rotation");
    string += "&" + "Mirror="      + (String)config.get("Mirror");
    string  = string.toLowerCase();

    cgiParamString = "";
    for (int i=0; i<string.length(); i++)
    {
      if (string.charAt(i)!=' ')
      {
        cgiParamString += string.charAt(i);
      }
    }
  }


  //--------------------------------------------------------
  // parse Param into hashtable
  //--------------------------------------------------------
  private void param2Hashtable()
  {
    config.put("Compression", m_comp.getItem(m_comp.getSelectedIndex()));
    config.put("Color",       m_color.getItem(m_color.getSelectedIndex()));
    config.put("Axislogo",    m_logo.getItem(m_logo.getSelectedIndex()));
    config.put("Clock",       m_clock.getItem(m_clock.getSelectedIndex()));
    config.put("Dark Detect", m_darkDetect.getItem(m_darkDetect.getSelectedIndex()));
    config.put("Rotation",    m_rotation.getItem(m_rotation.getSelectedIndex()));
    config.put("Mirror",      m_mirror.getItem(m_mirror.getSelectedIndex()));
    param2String();
  }


  //--------------------------------------------------------
  // read Config Param from hashtable
  //--------------------------------------------------------
  private void hashtable2Param()
  {
    m_comp.select((String)config.get("Compression"));
    m_color.select((String)config.get("Color"));
    m_logo.select((String)config.get("Axislogo"));
    m_clock.select((String)config.get("Clock"));
    m_darkDetect.select((String)config.get("Dark Detect"));
    m_rotation.select((String)config.get("Rotation"));
    m_mirror.select((String)config.get("Mirror"));
  }
}


